//
//  NSView+MCAdditions.h
//  MCApplication
//
//  Created by aj on Thu Oct 04 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>

@class MCGradientColor;
@interface NSView (MCAdditions) 

- (void)drawRoundedRect:(NSRect)rect cornerRadius:(float)radius
   usingColor:(NSColor *)color;
- (void)drawRoundedRect:(NSRect)rect cornerRadius:(float)radius
   usingColor:(NSColor *)color fill:(BOOL)flag;
- (void)drawRoundedRect:(NSRect)rect cornerRadius:(float)radius
    topLeft:(BOOL)tl topRight:(BOOL)tr 
    bottomLeft:(BOOL)bl bottomRight:(BOOL)br
    usingColor:(NSColor *)color fill:(BOOL)flag;


// Gradient
- (void)drawGradientInBounds:(NSRect)bounds withGradientColor:(MCGradientColor *)color;
- (void)drawVerticalGradientInBounds:(NSRect)bounds topGradientColor:(NSColor *)topColor bottomGradientColor:(NSColor *)bottomColor;

//returns the first view of type aClass or nil. walks the view tree bottom up. 
- (id)enclosingViewOfClass:(Class)aClass;
// returns the first view conforming to protocol aProtocol or nil. walks the view tree bottom up.
-(id)enclosingViewOfProtocol:(Protocol *)aProtocol;

- (NSClipView *)enclosingClipView; 


// Checks to see if self is of aClass,if so, returns self, otherwise passes is on to subviews. Returns nil is no view of class found
- (id)viewOfClass:(Class)aClass;

// does not check self if is of class aClass, but checks subviews
- (id)nestedSubviewOfClass:(Class)aClass;

// does a [[[self window] delegate] document]
// not a very same method - it returns only the current window's document. It assumes that the delegate of a window will be an NSWindowController who has a document
- (id)document;

// Tries to find the root window - meaning that if the view is in a drawer it will return the window which contains the drawer
- (id)rootWindow;


- (id)objectContext;

- (void)deepSetFocusRingType:(NSFocusRingType)focusRingType; // sets the focus ring type for every view in the heirarchy


// Makes the passed in view the top most view
- (void)makeSubviewTopMost:(id)aView;


- (void)runPrintOperationWithPrintInfo:(NSPrintInfo *)pi showPanels:(BOOL)flag;

// Image
- (NSImage *)imageRepresentation;
- (NSImage*)imageRepresentationForRect: (NSRect)rect;

// method without any arguments to just call setNeedsDisplay:YES, useful if you're doing something like
// performSelector afterDelaya
- (void)performSetNeedsDisplay;
@end
